@extends('admin.layouts.app')

@section('title', 'Data User')

@section('content')

    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-1">Data User</h4>
            <small class="text-muted">Manajemen akun pengguna</small>
        </div>

        <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#tambahUser">
            <i class="fas fa-plus me-2"></i>Tambah Data
        </button>
    </div>

    <div class="card shadow-sm border-0">
        <div class="card-body">

            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Nama</th>
                        <th>Email</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($user as $item)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $item->nama }}</td>
                            <td>{{ $item->email }}</td>
                            <td>
                                <span class="badge bg-info text-dark">
                                    {{ $item->role }}
                                </span>
                            </td>
                            <td>
                                <span class="badge {{ $item->status == 'isactive' ? 'bg-success' : 'bg-secondary' }}">
                                    {{ $item->status }}
                                </span>
                            </td>
                            <td class="text-center">
                                <button data-bs-target="#ubahUser{{ $item->id }}" data-bs-toggle="modal"
                                    class="btn btn-sm btn-warning">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                    data-bs-target="#hapusUser{{ $item->id }}">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
        @foreach ($user as $item)
            @include('admin.user.edit')
            @include('admin.user.delete')
        @endforeach
    </div>
    @include('admin.user.create')


@endsection
